% ccdb_test: Perform 3-fold cross validation on different versions of
%            the proposed method on the linear color checker database.
%
% [ae ei] = ccdb_test(in_dir, img_ext, out_dir, db_file)
%
%    in_dir:     Path to directory containing data files
%                (eg. '/data/shi')
%    img_ext:    Extension of the image files (eg. 'png')
%    out_dir:    Directory to save all the precomputed and training
%                data. Make sure this directory is on a device with
%                enough space--- for the color checker database,
%                the precomputed file for each image will be around
%                70MB. 
%    db_file:    .mat file containing image names, ground truth,
%                 mask data, category information. See the file
%                 cc_gt.mat provided with the source code as example.
%
%  Output:
%    ae:          Nx3 cell, containing angular errors of ML
%                 estimate, general prior and category-wise prior
%                 for each image.
%    ei:          Nx3x3 cell, where each ei(:,:,i) contains the
%                 estimated illuminants for the different
%                 strategies.


%   curentdir='/scratch/Soheila/MY MATLAB/Raw Database_ds';
clear
close all
curentdir='H:\CIM\Potential Research\spatio-spectral modeling\chz_cc2011\Synthesized Images';

  img_ext='png';
  out_dir=[curentdir,'/out_dir_edge'];
%   out_dir=[curentdir,'/out_dir_origin'];
%   db_file='cc_gt_ds.mat';
  db_file='cc_gt_synt.mat';
  in_dir=[curentdir];
  
  %% Main

  DB = open(db_file);
  
  N = length(DB.all_image_names);

  mode='edge';
% mode='chromaticity';
% mode='origin';
% mode='edge';
  
  % Do precomputation
  pc_names = cell(N,1);
  stsg = [1 2 4];
  sm=6;
  se{1} = strel('square',stsg(1)*sm);
  se{2} = strel('square',stsg(2)*sm);
  se{3} = strel('square',stsg(3)*sm);

  coeff=0.2;
  
  
  for i = 1:N
      
    tic
    i_name=[in_dir '/' DB.all_image_names{i} '.' img_ext];
    img = imread(i_name);

    pc_names{i} = [out_dir '/' DB.all_image_names{i} '.pc.mat'];
%         figure 
%         imshow(img)
    switch mode
          case 'edge'
                  mask=zeros(size(img));
                  img_avg=mean(img,3);
                  img_avg=mat2gray(img_avg);

                  BW = edge(img_avg,'sobel', coeff*median(img_avg(:)));
%                       name=sprintf('%s%d%s','img_edge',i,'.png');
%                       imwrite(imdilate(BW,strel('square',2)),name)
               for j=1:length(stsg)
                  
                  mask(:,:,j) = imdilate(double(BW),se{j});            
% %     figure
% %     imshow(mask(:,:,j))
% %     name=sprintf('%s%d%s','mask',j,'.png');
% %     imwrite(mask(:,:,j),name)
               end
               percentage(i)=sum(mask(:)/prod(size(mask)));
               precompute(double(img),pc_names{i},stsg,mask);
                clear('mask')
              
          case 'origin'
              mask = ones(size(img,1),size(img,2),3);
              percentage(i)=1;
              precompute(double(img),pc_names{i},stsg,mask);

        case 'chromaticity'
              mask=imdivide(double(img),100);
                name=sprintf('%s%d%s','mask',1,'.png');
                imwrite(mask(:,:,1),name)
                    name=sprintf('%s%d%s','mask',2,'.png');
                imwrite(mask(:,:,2),name)
                    name=sprintf('%s%d%s','mask',3,'.png');
                imwrite(mask(:,:,3),name)
              percentage(i)=mean(mask(:));
              precompute(double(img),pc_names{i},stsg,mask);
    
    end
    precomputation_time(i)=toc;
    fprintf(' Precomputing for %s masking percentage: %d exe_t: %4.2f\n',DB.all_image_names{i},floor(100*percentage(i)),precomputation_time(i));

  end;
  
  % Start testing
  svbase = [out_dir '/train'];
  truel = DB.groundtruth_illuminants;
  truel = truel ./ repmat(sqrt(sum(truel.^2,2)),[1 3]);

  ae = zeros([N 2]);
  ei = zeros([N 3 2]);
  exe_t = zeros([N 2]);
  
  for fold=1:3
      
      % ML
      tic
      train3fold(@train,pc_names,truel,svbase,fold)
      train_ML(fold)=toc
      [ae1 ei1 exe_t1] = test3fold(@estimate,out_dir,db_file,svbase,fold);
      ae(:,1) =ae(:,1)+ae1; ei(:,:,1) = ei(:,:,1)+ei1;exe_t(:,1) =exe_t(:,1)+exe_t1;
%       save precomputation_result
      
  end
        
  [mn1 md1 wst1]=report_errors(ae(:,1));
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,1)));
  
for fold=1:3
      
      % General Prior
      tic
      train3fold(@trainPrior,pc_names,truel,svbase,fold)  
      train_GP(fold)=toc
      [ae2 ei2 exe_t2] = test3fold(@estimatePrior,out_dir,db_file,svbase,fold);
      ae(:,2) =ae(:,2)+ ae2; ei(:,:,2) = ei(:,:,2)+ ei2; exe_t(:,2) =exe_t(:,2)+exe_t2;
%       save precomputation_result
end

  [mn2 md2 wst2]=report_errors(ae(:,2));
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,2)));

  for i=1:7
     aesubs=ae(i:7:end,1);
     a = sort(aesubs);
     a = a(ceil(0.75*length(a)):end); wst = mean(a);
     result1(i,:)=[mean(aesubs) median(aesubs) mean(a)];
 end
  
 
 for i=1:7
     aesubs=ae(i:7:end,2);
     a = sort(aesubs);
     a = a(ceil(0.75*length(a)):end); wst = mean(a);
     result2(i,:)=[mean(aesubs) median(aesubs) mean(a)];
 end
 
 figure
 plot([2:8],result1(:,1),'-or','Linewidth',2)
 hold on
 plot([2:8],result1(:,2),'--*','Linewidth',2)
 hold on
 plot([2:8],result1(:,3),'-*g','Linewidth',2)
 hold off
  set(gca,'fontweight','b')
 legend('mean','median','worst 25%')
 xlabel('Number of Surfaces')
 title('ML Estimate')
 
 figure
 plot([2:8],result2(:,1),'-or','Linewidth',2)
 hold on
 plot([2:8],result2(:,2),'--*','Linewidth',2)
 hold on
 plot([2:8],result2(:,3),'-*g','Linewidth',2)
 hold off
  set(gca,'fontweight','b')
 legend('mean','median','worst 25%')
 xlabel('Number of Surfaces')
 title('General Prior Estimate')

 

save('test_synt') 
  
  
  
  
  

      

